#include "Gate_OUTPUT.h"

Gate_OUTPUT::Gate_OUTPUT(int gateID, gType type, int numInputs, int gateLevel)
    : Gate_BASE(gateID, type, numInputs, gateLevel)
{
    // Override base gate to limit to one input point only
    this->xSize = BASE_GATE_SIZE_X + ADDITONAL_INPUTS;
    this->ySize = BASE_GATE_SIZE_Y + ADDITONAL_INPUTS;

    QPointF point = QPointF(0, this->ySize / 2);
    this->inputPoints[0] = point;
    QPointF scenePoint = QPointF(this->scenePos().x(), this->scenePos().y() + this->ySize / 2);
    this->gateInputPoints[0] = scenePoint;

    textRect = QRectF(BORDER_OFFSET * 2, BORDER_OFFSET, xSize - BORDER_OFFSET * 3, ySize - BORDER_OFFSET * 2);
}

void Gate_OUTPUT::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
{
    Q_UNUSED(widget);
    Q_UNUSED(option);

#ifdef _DEBUG
    painter->save();
    painter->setPen((auxSelected) ? debugSelectedPen : debugPen);
    painter->setBrush(debugBrush);
    painter->drawRect(0, 0, xSize, ySize);
    painter->drawRect(textRect);
    if (numInputs != 1) {
        painter->setPen(debugErrorPen);
        painter->drawLine(0, 0, xSize, ySize);
        painter->drawLine(xSize, 0, 0, ySize);
    }
    painter->restore();
#endif

    if (auxSelected) painter->setPen(highlightedPen);
    else painter->setPen(defaultPen);
    painter->setBrush(defaultBrush);

    // Draw circles indicating I/O points
    painter->drawEllipse(inputPoints[0], INPUT_CIRCLE_SIZE, INPUT_CIRCLE_SIZE);

    // Draw gate outline
    QPointF points[5] = {
        QPointF(BORDER_OFFSET, ySize / 2),
        QPointF(BORDER_OFFSET * 2, BORDER_OFFSET),
        QPointF(xSize - BORDER_OFFSET, BORDER_OFFSET),
        QPointF(xSize - BORDER_OFFSET, ySize - BORDER_OFFSET),
        QPointF(BORDER_OFFSET * 2, ySize - BORDER_OFFSET)
    };
    painter->drawPolygon(points, 5);

    // Draw I/O lines
    painter->drawLine(inputPoints[0], QPointF(inputPoints[0].x() + BORDER_OFFSET, inputPoints[0].y()));

    // Draw text showing gate ID
    painter->setPen(defaultPen);
    painter->setFont(defaultFont);
    painter->drawText(textRect, Qt::AlignCenter, QString::number(gateID));

    // If enqueued, draw circle around gate ID
    if (enqueued) {
        painter->drawEllipse(textRect.center(), ENQUEUED_CIRCLE_WIDTH, ENQUEUED_CIRCLE_WIDTH);
    }
}

void Gate_OUTPUT::simulateToOutput()
{
    // Do nothing
}
